package raytrans;

public class rtObject
{
	String   	name;
	Vertex[] 	vertex;
	Face[]   	face;
	Primitive[] primitive;
	Matrix[]    animation;

	public rtObject()
	{
		name      = null;
		vertex    = null;
		face	  = null;
		animation = null;
		primitive = null;
	}
	
	public rtObject(String s)
	{
		this();
		name = s;
	}
	
	public rtObject(rtObject rt)
	{
		name      = rt.name;
		vertex    = rt.vertex;
		face	  = rt.face;
		animation = rt.animation;
		primitive = rt.primitive;		
	}
	
	public Primitive[] getPrimitive()
	{
		return primitive;
	}
	
	public void setPrimitive(Primitive[] p)
	{
		primitive = p;
	}
	
	public void setTexture(rtLoader loader)
	{
		for ( int i = 0; i < primitive.length; i++ )
		{
			rtSurface surface;
			Material mat = primitive[i].getMaterial();
	
			if(mat.getTextureName() != null)
			{
				surface = loader.createRTSurface(mat.getTextureName());
				mat.setTexture(surface);
			}
		
			if(mat.getAlphaName() != null)
			{
				surface = loader.createRTSurface(mat.getAlphaName());
				mat.setAlpha(surface);
			}
		}
	}

	public Matrix getAnimation(int i)
	{
		if ( animation == null )
		{
			return new Matrix();
		}
		else
		{
			return animation[i];
		}
	}
	
	public int getAnimationLength()
	{
		if ( animation == null )
		{
			return -1;
		}
		else
		{
			return animation.length;
		}
	}
}
