package raytrans;

import java.applet.Applet;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
//------------------------------------------------------
//_[
//
//------------------------------------------------------
public class rtRender
{	
	private Matrix mWorld;  //[hϊs
	private Matrix mMaster; //}X^[s
	private Matrix mProj;   //ˉeϊs
	private Matrix mView;   //r[s

	static public final int TRANSFORM_WORLD = 0;
	static public final int TRANSFORM_VIEW  = 1;
	static public final int TRANSFORM_PROJ  = 2;
	//--------------------------------------------------------------------
	//o
	//
	//--------------------------------------------------------------------
	private rtSurface pbuf;		//32bitsNZobt@
	private int zbuf[];		//32bityobt@
	private int backbuf[];	//wi摜obt@
	private int backColor = 0xffffffff;	//wiF
	
	private int BUFFERW;		//obt@
	private int BUFFERH;		//obt@
	private int CENTERX;
	private int CENTERY;

	private int min [];
	private int max [];
	private int minz[];
	private int maxz[];

	private int minr[];
	private int maxr[];
	private int ming[];
	private int maxg[];
	private int minb[];
	private int maxb[];

	private int minsr[];
	private int maxsr[];
	private int minsg[];
	private int maxsg[];
	private int minsb[];
	private int maxsb[];

	private int minu[];
	private int maxu[];
	private int minv[];
	private int maxv[];

	private int renderMode;
	private boolean ImageTrans;

	static final private int USE_ALL_TEXTURE = 0;
	static final private int USE_PATTERN_TEXTURE = 1;
	static final private int USE_TRANSPARENCY_TEXTURE = 2;
	static final private int NOT_USE_TEXTURE = 3;
	static final int NUM_OF_RENDER = 4;	// Renderingp^[

	private MemoryImageSource memImgSrc;
	private rtImageTranscoder rtImgTrans;

	private Image offImage;
	
	public Vector cameraPos;
	public Vector cameraDest;

	//--------------------------------------------------------------------
	//RXgN^
	//
	//--------------------------------------------------------------------
	public rtRender(Applet applet,int w,int h)
	{
		mWorld  = new Matrix();//[hϊs
		mMaster = new Matrix();//}X^[s
		mProj   = new Matrix();//ˉeϊs
		mView   = new Matrix();//r[s

		BUFFERW = w;
		BUFFERH = h;
		CENTERX = BUFFERW/2;
		CENTERY = BUFFERH/2;
		
		pbuf = new rtSurface(BUFFERW,BUFFERH);
		zbuf = new int[BUFFERW * BUFFERH];
		min  = new int[BUFFERH];
		max  = new int[BUFFERH];
		//
		for(int i=0;i<BUFFERH;i++)
		{
			min[i] = +2147483647;
			max[i] = -2147483648;
		}

		minz = new int[BUFFERH];
		maxz = new int[BUFFERH];

		minr = new int[BUFFERH];
		maxr = new int[BUFFERH];
		ming = new int[BUFFERH];
		maxg = new int[BUFFERH];
		minb = new int[BUFFERH];
		maxb = new int[BUFFERH];

		minsr = new int[BUFFERH];
		maxsr = new int[BUFFERH];
		minsg = new int[BUFFERH];
		maxsg = new int[BUFFERH];
		minsb = new int[BUFFERH];
		maxsb = new int[BUFFERH];

		minu = new int[BUFFERH];
		maxu = new int[BUFFERH];
		minv = new int[BUFFERH];
		maxv = new int[BUFFERH];

		memImgSrc = new MemoryImageSource(BUFFERW,BUFFERH,pbuf.getBuffer(),0,BUFFERW);
		memImgSrc.setAnimated(true);
		memImgSrc.setFullBufferUpdates(true);

		rtImgTrans = new rtImageTranscoder();

		offImage = applet.createImage(memImgSrc);

		light = new Vector();
		eye   = new Vector();
		tmp = new Vector();
		cameraPos = new Vector();
		cameraDest = new Vector();

		renderMode = USE_ALL_TEXTURE;
	}
	
	public void setCamera(Vector e,Vector d)
	{
		Matrix m = new Matrix();
		//J
		m.View(e,d,new Vector(0,1,0));
		SetTransform(TRANSFORM_VIEW,m);

		cameraPos = e;
		cameraDest = d;
	}

	public void setBackImage(Image back)
	{
		if(back == null) return;

		backbuf = new int[BUFFERW * BUFFERH];

		PixelGrabber pg =
			 new PixelGrabber(back,0,0,BUFFERW,BUFFERH,backbuf,0,BUFFERW);

		try{
			pg.grabPixels();
		}catch(InterruptedException e){
			backbuf = null;
		}

	}

	//--------------------------------------------------------------------
	//obt@̃NA
	//
	//--------------------------------------------------------------------
	public void Clear()
	{
		//offImagẽ\[XJ
		offImage.flush();

		//wi΁Awi݁AΔwiFœhԂ
		if(backbuf != null)
		{
			pbuf.copy(backbuf);
		}
		else
		{
			pbuf.fill(backColor);
		}

		for (int i=zbuf.length-1;i>=0;i--)
		{
			
			zbuf[i] = 2147483647;
		}

	}
	
	//--------------------------------------------------------------------
	//_OJn
	//
	//--------------------------------------------------------------------

	public void BeginScene()
	{
		BeginScene(0xffffffff);
	}

	public void BeginScene(int c)
	{
		Matrix m = new Matrix();

		backColor = c;

		//ˉeϊ}gNX
		m.Projection(40,4000,(float)Math.PI/6,(float)BUFFERH/(float)BUFFERW);
		SetTransform(TRANSFORM_PROJ,m);

		//obNobt@NA
		Clear();
	}
	
	//--------------------------------------------------------------------
	//_OI
	//
	//
	//------------------------------------------------------------------
	public Image endScene()
	{
		rtImgTrans.TranscodeImage(pbuf);
		memImgSrc.newPixels();
		
		//	ImageCX^X𐶐āAԂB
		return offImage;
	}

	//--------------------------------------------------------------------
	//ϊsݒ肷B
	//
	//Matrix m ...ϊs
	//--------------------------------------------------------------------
	public void SetTransform(int type,Matrix m)
	{
		switch(type){
		case TRANSFORM_WORLD:
			mWorld.Initialize(m);
			break;
		case TRANSFORM_PROJ:
			mProj.Initialize(m);
			break;
		case TRANSFORM_VIEW:
			mView.Initialize(m);
			break;
		}
	}

	//--------------------------------------------------------------------
	//v~eBu`
	//
	//--------------------------------------------------------------------
	static public Vector light;
	static private Vector eye;
	private Vector tmp;

	public void DrawIndexedPrimitive(Primitive[] obj)
	{
		Vertex[] vertex;
		int[] V;
		int end;
		Matrix im = new Matrix(); //[h]us
		TLVertex[] tltx = null;

		mMaster.Initialize();
		mMaster.Mult(mWorld);
		
		//[h]us̍쐬
		im.Invert(mMaster);

		//š
		light = im.Transform(new Vector(-1,-1,1));
		light.Normalize();

		//[hEr[]us̍쐬
		mMaster.Mult(mView);
		im.Invert(mMaster);

		//xNg
		eye = im.Transform( new Vector(0,0,1));
		eye.Normalize();

		//}X^[s̍쐬
		mMaster.Mult(mProj);

		for (int i=0;i<obj.length;i++)
		{
			Primitive object = obj[i];

			vertex = object.vertex;
			V      = object.V_index;
			end    = V.length;

			tltx = LightingAndTransform(tltx,object);

			for (int j=0;j<end;j+=3){

				final int i1 = j;
				final int i2 = j+1;
				final int i3 = j+2;

				//@xNg߂B
				tmp.calcNormal(vertex[V[i1]].v,vertex[V[i2]].v,vertex[V[i3]].v);
				final float e = eye.DotProduct(tmp);

				if ( e > 0 )
				{

					ScanEdge(tltx[V[i1]],tltx[V[i2]]);
					ScanEdge(tltx[V[i2]],tltx[V[i3]]);
					ScanEdge(tltx[V[i3]],tltx[V[i1]]);

					DrawPolygon(object);
				}
			}
		}

	}

	private TLVertex[] LightingAndTransform(TLVertex[] tltx,Primitive obj)
	{
		final Vertex[] vertex = obj.vertex;

		TLVertex TV = new TLVertex();

		int end = vertex.length;

		tltx = new TLVertex[end];

		for(int i=end-1;i>=0;i--)
		{
			TV.setZERO();

			OneVertexTransform(TV,vertex[i]);
			OneVertexLighting(TV,vertex[i],obj.mat);

			tltx[i] = new TLVertex(TV);
		}

		final int[] V_index = obj.V_index;
		final int[] UV_U = obj.UV_U_ind;
		final int[] UV_V = obj.UV_V_ind;

		end = V_index.length;

		for(int i=end-1;i>=0;i--)
		{
			TV = tltx[V_index[i]];
			
			TV.u = UV_U[i];
			TV.v = UV_V[i];
		}

		return tltx;

	}

	//--------------------------------------------------------------------
	//Wϊ
	//
	//--------------------------------------------------------------------
	private void OneVertexTransform(TLVertex out,Vertex in)
	{
		mMaster.Transform(in.v,tmp);

		final float _z = 1.0f / tmp.z;

		out.x = (int)((CENTERX + tmp.x * _z * CENTERX))<<16;
		out.y = (int)((CENTERY - tmp.y * _z * CENTERY))<<16;
		out.z = (int)(tmp.z * 0xffff);

	}

	private void OneVertexLighting(TLVertex TV,Vertex V,Material mat)
	{
		final float w = light.DotProduct(V.n);

		int r,g,b;

		if(w < 0)
		{
			r = ( mat.Amb + mat.Emi ) << 16;
			g = ( mat.Amb + mat.Emi ) << 16;
			b = ( mat.Amb + mat.Emi ) << 16;

			TV.setColor((r << 16),(g << 16),(b << 16));

			TV.setZEROSpcColor();

		}
		else
		{
			tmp.set(V.n);

			//XyL[
			tmp.x = tmp.x * 2 * w - light.x;
			tmp.y = tmp.y * 2 * w - light.y;
			tmp.z = tmp.z * 2 * w - light.z;
			tmp.Normalize();

			r = (int)((mat.Amb + mat.Emi) + w * mat.D);
			g = (int)((mat.Amb + mat.Emi) + w * mat.D);
			b = (int)((mat.Amb + mat.Emi) + w * mat.D);

			if (r > 255)  r = 255;
			if (g > 255)  g = 255;
			if (b > 255)  b = 255;

			TV.setColor((r << 16),(g << 16),(b << 16));

			//xNgƔ˃xNgƂ̓
			float sw = tmp.DotProduct(eye);

			//ςOȏȂ΁AXyL[vZ

			if(sw > 0)
			{
				sw = (float)Math.pow(sw,mat.PW); //

				r = (int)(sw * mat.S );
				g = (int)(sw * mat.S );
				b = (int)(sw * mat.S );

				if (r > 255)  r = 255;
				if (g > 255)  g = 255;
				if (b > 255)  b = 255;

				TV.setSpcColor((r << 16),(g << 16),(b << 16));

			}
			else
			{
				TV.setZEROSpcColor();
			}

		}
	}

	//DrawPolygonScanEdgeŎgp
	//
	private int l;
	private int addx;
	private int addy;
	private int addz;
	private int addu;
	private int addv;
	private int addr;
	private int addg;
	private int addb;
	private int addsr;
	private int addsg;
	private int addsb;

	//--------------------------------------------------------------------
	//|S`
	//
	//--------------------------------------------------------------------
	private void DrawPolygon(Primitive obj)
	{
		int z;
		int u;
		int v;

		int p;

		int r,g,b,a;
		int sr,sg,sb;

		int tr,tg,tb;

		int offset;

		int texel;

		final int[] cbuf = pbuf.getBuffer();

		int[] tbuf = null;
		int[] abuf = null;

		if( (renderMode & 2) == 0 ) tbuf = obj.mat.getTextureBuffer();
		if( (renderMode & 1) == 0 ) abuf = obj.mat.getAlphaBuffer();

		final int TEXWIDTH  = obj.mat.getTextureWidth();
		final int TEXHEIGHT = obj.mat.getTextureHeight();
		final int ALPWIDTH  = obj.mat.getAlphaWidth();
		final int ALPHEIGHT = obj.mat.getAlphaHeight();

		final rtColor C = obj.mat.getColor();
		
		for (int y=0;y<BUFFERH;y++){
			
			//obt@XVȂXLbv
			if (min[y] == +2147483647) continue;
			
			offset = y * BUFFERW;
			
			//lvZ
			l = (max[y] - min[y]) + 1;
			addz = (maxz[y] - minz[y]) / l;
			addu = (maxu[y] - minu[y]) / l;
			addv = (maxv[y] - minv[y]) / l;
			addr = (maxr[y] - minr[y]) / l;
			addg = (maxg[y] - ming[y]) / l;
			addb = (maxb[y] - minb[y]) / l;
			addsr = (maxsr[y] - minsr[y]) / l;
			addsg = (maxsg[y] - minsg[y]) / l;
			addsb = (maxsb[y] - minsb[y]) / l;

			//lݒ
			z = minz[y];
			u = minu[y];
			v = minv[y];
			r = minr[y];
			g = ming[y];
			b = minb[y];
			sr = minsr[y];
			sg = minsg[y];
			sb = minsb[y];
			
			for (int x=min[y];x<=max[y];x++,z+=addz,u+=addu,v+=addv,
											r+=addr,g+=addg,b+=addb,
											sr+=addsr,sg+=addsg,sb+=addsb)
			{
			
				if (x < 0 || x >=BUFFERW) continue;
				
				p = offset + x;

				//Zobt@Ƃ̔r
				if (zbuf[p] > z){
					//eNX`gpĂȂ΁A
					//eNX`obt@ƂtulF߂B
					//gpĂȂ΁Aގ̐FgpB
					if(abuf != null)
					{
						texel = 
							abuf[(((v & 0xffff)*ALPHEIGHT)>>16)*ALPWIDTH + (((u & 0xffff)*ALPWIDTH)>>16)];

						if( (texel & 0xffffff) == 0 ) continue;
						else if( (texel & 0xffffff) == 0xffffff) a = 0xff;
						else a = ( ((texel & 0xff0000)>>16) + ((texel & 0x00ff00)>>8) + (texel & 0x0000ff) ) / 3;
					}
					else a = C.a;

					if(tbuf != null)
					{

						texel = 
							tbuf[(((v & 0xffff)*TEXHEIGHT)>>16)*TEXWIDTH + (((u & 0xffff)*TEXWIDTH)>>16)];
						//qfalɕ

						tr = (( (r>>16) * ((texel & 0xff0000)>>16) )>>8) + (sr>>16);
						tg = (( (g>>16) * ((texel & 0x00ff00)>>8 ) )>>8) + (sg>>16);
						tb = (( (b>>16) * ((texel & 0x0000ff)    ) )>>8) + (sb>>16);
					}
					else
					{
						tr = ( ( (r>>16) * C.r ) >> 8 )  + (sr>>16);
						tg = ( ( (g>>16) * C.g ) >> 8 )  + (sg>>16);
						tb = ( ( (b>>16) * C.b ) >> 8 )  + (sb>>16);
					}

					if (tr > 255) tr = 255;
					if (tg > 255) tg = 255;
					if (tb > 255) tb = 255;

					cbuf[p] = AlphaBlending(( tr<< 16 | tg<< 8 | tb),( 0xffffff & cbuf[p]),a);
					zbuf[p] = z;
				}
			}

			//
			min[y] = +2147483647;
			max[y] = -2147483648;

		}
	}

	//--------------------------------------------------------------------
	//XLC
	//
	//Vector v1 ...n_
	//Vector v2 ...I_
	//--------------------------------------------------------------------
	final private void ScanEdge(TLVertex v1,TLVertex v2)
	{		

		final int xl = ( ( Math.abs( v2.x - v1.x ) ) >>16 ) +1;
		final int yl = ( ( Math.abs( v2.y - v1.y ) ) >>16 ) +1;

		if(xl > yl) l = xl; else l = yl;
	
		//lvZ
		addx = (v2.x - v1.x) / l;
		addy = (v2.y - v1.y) / l;
		addz = (v2.z - v1.z) / l;
		addu = (v2.u - v1.u) / l;
		addv = (v2.v - v1.v) / l;
		addr = (v2.r - v1.r) / l;
		addg = (v2.g - v1.g) / l;
		addb = (v2.b - v1.b) / l;
		addsr = (v2.sr - v1.sr) / l;
		addsg = (v2.sg - v1.sg) / l;
		addsb = (v2.sb - v1.sb) / l;
		
		//lݒ
		int x = v1.x;
		int y = v1.y;
		int z = v1.z;
		int u = v1.u;
		int v = v1.v;
		int r = v1.r;
		int g = v1.g;
		int b = v1.b;
		int sr = v1.sr;
		int sg = v1.sg;
		int sb = v1.sb;

		int py,px,pz;
		
		//XL
		for (int i=0;i<l;i++,x+=addx,y+=addy,z+=addz,u+=addu,v+=addv,
							 r+=addr,g+=addg,b+=addb,
							 sr+=addsr,sg+=addsg,sb+=addsb)
		{
			py = y>>16;
			px = x>>16;
			pz = z;
			
			if (py < 0 || py >= BUFFERH) continue;
							
			if (min [py] > px){
				min [py] = px;
				minz[py] = pz;
				minu[py] = u;
				minv[py] = v;
				minr[py] = r;
				ming[py] = g;
				minb[py] = b;
				minsr[py] = sr;
				minsg[py] = sg;
				minsb[py] = sb;
			}
			
			if (max [py] < px){
				max [py] = px;
				maxz[py] = pz;
				maxu[py] = u;
				maxv[py] = v;
				maxr[py] = r;
				maxg[py] = g;
				maxb[py] = b;
				maxsr[py] = sr;
				maxsg[py] = sg;
				maxsb[py] = sb;
			}
		}
	}

	private int AlphaBlending(int c1, int c2,int a)
	{

		//̐F
		final int c2R = (((c2 & 0xff0000)>>16) * (255 - a) ) >> 8;
		final int c2G = (((c2 &   0xff00)>> 8) * (255 - a) ) >> 8;
		final int c2B = (((c2 &     0xff)    ) * (255 - a) ) >> 8;

		//O̐F
		final int c1R = (((c1 & 0xff0000)>>16) * a) >> 8;
		final int c1G = (((c1 &   0xff00)>> 8) * a) >> 8;
		final int c1B = (((c1 &     0xff)    ) * a) >> 8;

		int tr = c2R + c1R;
		int tg = c2G + c1G;
		int tb = c2B + c1B;

		if(tr > 255) tr = 255;
		if(tg > 255) tg = 255;
		if(tb > 255) tb = 255;

		return 0xff000000 | tr << 16 | tg << 8 | tb;

	}

	public void changeRenderMode()
	{
		renderMode++;
		renderMode %= NUM_OF_RENDER;
	}

	public int getRenderMode()
	{
		return renderMode;
	}

	public void setColorMode(int i)
	{
		rtImgTrans.setMode(i);
	}

	public void changeColorMode()
	{
		rtImgTrans.changeMode();
	}

	public int getColorMode()
	{
		return rtImgTrans.getMode();
	}
}

