package raytrans;

import java.awt.Image;
import java.awt.image.PixelGrabber;

public final class rtSurface
{
	String name;
	//T[tFCX̍쐬
	private int[] mBuffer;	//32bitobt@
	private int   mWidth;	//obt@̕
	private int   mHeight;	//obt@̍
	private int   mShift;

	public rtSurface()
	{
		mWidth  = -1;
		mHeight = -1;
		mBuffer = null;
	}

	public rtSurface(String s)
	{
		this();
		setName(s);
	}

	public rtSurface(Image image)
	{
		this();
		create(image);
	}
	
	public rtSurface(int w,int h)
	{
		create(w,h,0x000000);
	}

	public rtSurface(int w,int h,int color)
	{
		create(w,h,color);
	}

	public rtSurface(rtSurface surface)
	{
		set(surface);
	}

	public rtSurface(int w,int h,int[] pixel)
	{
		create(w,h,pixel);
	}

	public void set(rtSurface surface)
	{
		if(surface != null)
		{
			createBuffer(surface.mWidth,surface.mHeight);

			if(surface.getBuffer() != null)
			{
				copyBuf(surface.mBuffer);
			}

			setName(surface.name);

		}
	}

	private void createBuffer(int w,int h)
	{
		this.mWidth  = w;
		this.mHeight = h;
		this.mShift = get2N(mWidth);
		
		if( (mWidth > -1) || (mHeight > -1))
		{
			mBuffer = new int[mWidth * mHeight];
		}
		else
		{
			mBuffer = null;
		}
	}

	public void create(int w,int h,int color)
	{		
		createBuffer(w,h);
		fill(color);
	}

	public boolean create(int w,int h,int[] pixel)
	{
		createBuffer(w,h);
		if( !copyBuf(pixel) ) return false;

		return true;
	}

	//摜t@CT[tFCX쐬
	public boolean create(Image image)
	{
		if(image == null) return false;

		final int w = image.getWidth (null);
		final int h = image.getHeight(null);

		createBuffer(w,h);

		//sNZ擾
		final PixelGrabber pg = new PixelGrabber(image,0,0,mWidth,mHeight,mBuffer,0,mWidth);
		
		try
		{
			pg.grabPixels();
		}
		catch(InterruptedException e)
		{
			System.out.println("InterruptedException");
			return false;
		}
		
		return true;
	}
	
	//hԂ
	public void fill(int c)
	{
		final int n = mWidth * mHeight;
		for (int i=n-1;i>=0;i--)
			mBuffer[i] = c;
	}
	
	//Rs[
	public boolean copy(rtSurface s)
	{
		if (s.getWidth()  != getWidth ()) return false;
		if (s.getHeight() != getHeight()) return false;
		
		copyBuf(s.getBuffer());
		
		return true;
	}

	public boolean copy(int[] c)
	{
		if(mBuffer.length != c.length) return false;
		copyBuf(c);

		return true;
	}

	private boolean copyBuf(int[] c)
	{
		if((mBuffer == null) | (c == null)) return false;

		final int n = mBuffer.length;
		for(int i=n-1;i>=0;i--)
		{
			mBuffer[i] = c[i];
		}
		return true;
	}

	public void setName(String name)
	{
		if(name != null) this.name = new String(name);
		else name = null;
	}

	public String getName()
	{
		return name;
	}

	//擾
	public int getWidth()
	{
		return mWidth;
	}
	
	//擾
	public int getHeight()
	{
		return mHeight;
	}
			
	//obt@擾
	public int[] getBuffer()
	{
		return mBuffer;
	}

	//Vtg擾
	private int get2N(int n)
	{ 
		n--; 
		n  = (n & 0x55555555) + (n >>> 1 & 0x55555555); 
		n  = (n & 0x33333333) + (n >>> 2 & 0x33333333); 
		n  = ((n >>> 4) + n) & 0x0f0f0f0f;
		n += ( n >>> 8); 
		n += ( n >>>16) & 0xff;

		return (n&31); 
	}

}