Texture2D g_texDecal: register(t0);
SamplerState g_samLinear : register(s0);

cbuffer global
{
	matrix g_mWVP;
	float4 g_vColor;
};

struct VS_OUTPUT
{
	float4 m_Pos    : SV_POSITION;
    float2 m_Tex    : TEXCOORD1;
};

VS_OUTPUT VS( float4 Pos : POSITION, float2 Tex : TEXCOORD)
{
	VS_OUTPUT output = (VS_OUTPUT)0;
	
	output.m_Pos = mul(Pos,g_mWVP);
	output.m_Tex = Tex;

	return output;
}

float4 PS( VS_OUTPUT input ) : SV_Target
{
	return saturate(g_vColor);
}

float4 PS_TEX( VS_OUTPUT input ) : SV_Target
{
	float4 tex_col = g_texDecal.Sample( g_samLinear, input.m_Tex );

	return saturate(tex_col);
}
